set terminal png size 500,500 font "Arial,14" 
set output "pm3d-linear.png"

set title "Spectrogram"
set xlabel "Time(sec)"
set ylabel "Frequency(Hz)"
set cblabel "power(dB)"
set nokey

#set grid
#set border linewidth 2	#̑
#set tic scale 1,0.5	#̒
#set tic scale 0.5		#̒
#set mxtics 2			#̕
set mytics 2			#̕

set cbtics 20			#J[o[̖ڐ̊Ԋu
set mcbtics 2			#J[o[̏̕

set lmargin 3			#}[W
set bmargin 3
set rmargin 3
set tmargin 3
set size ratio 1.0		#c̔䗦

set xrange[0:] 
set yrange[0:6000]
set cbrange [-20:90] 

set pm3d interpolate 4, 4		#⊮

set view map 
splot "out.dat" using 1:2:(4.3429*log($3)+6.0207) with pm3d	#OXP[p
